function setSpeeds(self)
	local dir = self.Direction
	if dir < 1 or dir > 9 then
		self.SpeedX, self.SpeedY = 0, 0
		return
	end
	local mod3 = dir % 3
	local multX = mod3 == 0 and 1 or mod3 == 1 and -1 or 0
	local multY = dir <= 3 and 1 or dir >= 7 and -1 or 0
	self.SpeedX = multX * self.Speed
	self.SpeedY = multY * self.Speed
end

function main(self)
	if self.State == 0 then
		self.HitRect = {-60,-8,64,32}
		self.BumpFlags.Platform = true
		self.Flags.AlwaysActive = true
		self:SetImage("CUSTOM_ELEVATORLONG")
		self.startingX, self.startingY = self.X, self.Y
		setSpeeds(self)
		self.attempts = Attempt()
		self.State = 3
	end

	-- Trigger movement:
	if self.State == 1 then
		self.attempts = Attempt()
		self.State = 2
	end

	-- Movement: 
	if self.State == 2 then
		self.MoveClawX = self.SpeedX
		self.X = self.X + self.SpeedX
		if self.SpeedX ~= 0 and (self.X > self.XMax or self.X < self.XMin) then
			self.State = 3
		end
		self.MoveClawY = self.SpeedY
		self.Y = self.Y + self.MoveClawY
		if self.SpeedY ~= 0 and (self.Y > self.YMax or self.Y < self.YMin) then
			self.State = 3
		end
	end

	-- Stop: 
	if self.State == 3 then
		self.MoveClawX, self.MoveClawY = 0, 0
	end

	-- Reset if Claw dies:
	if self.State > 0 and Attempt() > self.attempts then
		self.X, self.Y = self.startingX, self.startingY
		self.State = 3
	end
end